using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;

using VirtualLab.Programming;
using VirtualLab.Design;
using VirtualLabAPI.Core.BasicFunctions;
using VirtualLabAPI.Core.Common;
using VirtualLabAPI.Core.DataVisualization;
using VirtualLabAPI.Core.FieldRepresentations;
using VirtualLabAPI.Core.Functions;
using VirtualLabAPI.Core.GeometryDescription;
using VirtualLabAPI.Core.LightPath;
using VirtualLabAPI.Core.Materials;
using VirtualLabAPI.Core.Modules;
using VirtualLabAPI.Core.Numerics;
using VirtualLabAPI.Core.Numerics.Region2D;
using VirtualLabAPI.Core.OpticalSystems;
using VirtualLabAPI.Core.Propagation;
using VirtualLabAPI.Core.SupportFunctions;

namespace OwnCode {
    public class VLModule : IVLModule {
        public void Run() {
            
            DataArray2D desiredPhaseProfile = (DataArray2D) VL_GUI.SelectOpenDataArray2D("Select Desired Phase Profile");
            DataArray1D diameterPhaseLookupTable = (DataArray1D) VL_GUI.SelectOpenDataArray1D("Select Diameter-Phase Lookup Table");
            
            // extract the actual data container in "ComplexField" format
            ComplexField phaseProfile = desiredPhaseProfile.Data[0];
            // initialize container for pillar diameters
            double[,] diameterProfile = new double[phaseProfile.SamplingPoints.X, phaseProfile.SamplingPoints.Y];
            // define diameter values in a loop
            for (int iy = 0; iy < phaseProfile.SamplingPoints.Y; iy++)
            {
                for (int ix = 0; ix < phaseProfile.SamplingPoints.X; ix++)
                {
                    // get current phase value
                    double phaseValue = phaseProfile[ix, iy].Re;
                    // find corresponding diameter
                    long dummyOutLong;
                    bool dummyOutBool;
                    double diameterValue = diameterPhaseLookupTable.PointInterpolation(phaseValue,
                        true,
                        out dummyOutLong,
                        out dummyOutBool)[0].Re;
                    // fill the value
                    diameterProfile[ix, iy] = diameterValue;
                }
            }
            // display
            DataArray2D diameterProfileDataArray = new DataArray2D(diameterProfile,
                PhysicalProperty.Length,
                "Pillar Diameter",
                desiredPhaseProfile.SamplingDistance_X,
                desiredPhaseProfile.CoordinateOfFirstDataPoint_X,
                desiredPhaseProfile.PhysicalPropertyOf_X_Coordinates,
                desiredPhaseProfile.CommentOfCoordinates_X,
                desiredPhaseProfile.SamplingDistance_Y,
                desiredPhaseProfile.CoordinateOfFirstDataPoint_Y,
                desiredPhaseProfile.PhysicalPropertyOf_Y_Coordinates,
                desiredPhaseProfile.CommentOfCoordinates_Y);
            Globals.DataDisplay.ShowDocument(diameterProfileDataArray, "Pillar Diameter");
            
        }
    }
}